"""Cutlery props."""
from mojo import Mojo

from bigym.const import ASSETS_PATH
from bigym.envs.props.prop import Prop

FORK_PATH = ASSETS_PATH / "props/cutlery/fork/fork.xml"


class Fork(Prop):
    """Fork."""

    def __init__(self, mojo: Mojo):
        """Init."""
        super().__init__(mojo, FORK_PATH, True, True)


KNIFE_PATH = ASSETS_PATH / "props/cutlery/knife/knife.xml"


class Knife(Prop):
    """Knife."""

    def __init__(self, mojo: Mojo):
        """Init."""
        super().__init__(mojo, KNIFE_PATH, True, True)


SPOON_PATH = ASSETS_PATH / "props/cutlery/spoon/spoon.xml"


class Spoon(Prop):
    """Spoon."""

    def __init__(self, mojo: Mojo):
        """Init."""
        super().__init__(mojo, SPOON_PATH, True, True)


SPATULA_PATH = ASSETS_PATH / "props/spatula/spatula.xml"


class Spatula(Prop):
    """Spatula."""

    def __init__(self, mojo: Mojo):
        """Init."""
        super().__init__(mojo, SPATULA_PATH, True, True)
